% ALPHA ENGINE DEFINITION
% Generated 16-May-2018 14:55:19

% SUGGESTED CITATION:
% 2016 Honda 1.5L L15B7 Engine Tier 2 Fuel - ALPHA Map Package. Version 2018-05. Ann Arbor MI: US EPA National Vehicle and Fuel Emissions Laboratory, National Center for Advanced Technology, 2018.


% Constructor
engine = class_REVS_engine();
engine.name =  '2016 Honda 1.5L L15B7 Engine Tier 2 Fuel'; 
engine.source_filename = mfilename;engine.matrix_vintage = enum_matrix_vintage.present;

% Physical Description
engine.displacement_L =  1.496; 
engine.num_cylinders =  4; 
engine.combustion_type = enum_engine_combustion_type.spark_ignition;
engine.compression_ratio =  10.6; 
engine.stroke_mm =  89.4; 

% Maximum Torque Curve
engine.full_throttle_speed_radps = [	    0.00000000000000000	;     104.82447487477941	;     131.00441365469436	;     157.26795223911657	;     168.02432201562254	;     179.82127283297581	;     210.70012400031695	;     262.18471583012371	;     314.42814040590815	;     418.66041798982678	;     471.45777176088114	;     523.71863555897801	;     628.31853071795865	;     659.73445725385659	;     691.15038378975453		]; 
engine.full_throttle_torque_Nm = [	    0.00000000000000000	;     129.73300000000000	;     138.88900000000001	;     196.48857142857136	;     216.18408450704220	;     231.80737179487164	;     237.22968354430384	;     231.20378640776678	;     232.98675675675668	;     216.79837499999999	;     218.27288288288278	;     213.47463855421688	;     206.90142601946394	;     177.34407944525483	;    0.00000000000000000		]; 
engine.naturally_aspirated_speed_radps = [	    0.00000000000000000	;     105.56499314312563	;     145.31175019791789	;     209.41804553170351	;     235.76982189659736	;     313.94414767686396	;     366.53565567091692	;     418.81305632013954	;     471.23347076158126	;     575.92905570908874	;     691.15038378975453		]; 
engine.naturally_aspirated_torque_Nm = [	     127.25433308808792	;     118.02406210272611	;     111.60480809272713	;     110.47550668286338	;     108.25419627283021	;     93.973174240450220	;     91.225423185045742	;     98.570482637620827	;     120.33571820243844	;     128.51804237420095	;     133.99665009501905		]; 

% Minimum Torque Curve
engine.closed_throttle_speed_radps = [	    0.00000000000000000	;     104.82447487477941	;     314.15926535897933	;     471.13417828334929	;     523.49405584317913	;     691.15038378975453		]; 
engine.closed_throttle_torque_Nm = [	    -12.616064532266137	;    -15.576000000000001	;    -19.555000000000000	;    -24.587000000000000	;    -27.398000000000000	;    -32.132122561280639		]; 

% Fuel Map
engine.fuel_map_speed_radps = [	    0.00000000000000000	;     39.616065138184624	;     79.232130276369247	;     105.56499314312563	;     131.00441365469436	;     145.31175019791789	;     157.23361751852565	;     167.84483860204938	;     183.43694188258033	;     209.41804553170351	;     235.76982189659736	;     261.75930773146854	;     313.94414767686396	;     335.83625466874889	;     366.53565567091692	;     418.81305632013954	;     471.23347076158126	;     523.53958070021872	;     575.92905570908874	;     628.31853071795865	;     659.73445725385659	;     691.15038378975453		]; 
engine.fuel_map_torque_Nm = [	    -33.738728689344676	;    -18.950954545454543	;    -6.1059999999999999	;    -2.1090000000000000	;     4.6198793103448272	;     10.916708333333332	;     17.973519999999997	;     31.025874999999999	;     41.305571428571426	;     51.404458333333338	;     61.522999999999996	;     71.497470588235302	;     83.182166666666660	;     95.544678571428577	;     105.10225000000000	;     115.69657142857142	;     127.70781249999999	;     139.56774999999999	;     150.58550000000002	;     163.25886388559360	;     176.90957578284284	;     184.41863502517006	;     187.05545070422536	;     194.47010369843190	;     203.26756357623432	;     206.12162713843639	;     213.36776796789241	;     222.00001928484971	;     230.63227060180699	;     239.86171916166302	;     249.09116772151904		]; 
engine.fuel_map_gps = [
   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	  0.020649426305408003	  0.092236732134359137	   0.16070284036740642	;
  0.026545682857869474	 0.0073029216407502675	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	  0.014653529740801068	  0.033446041305979252	  0.061959001753250836	   0.13043128999690018	   0.24551013933669355	   0.38568835853497851	   0.43902112791002063	   0.49539667597179038	   0.53714821162237014	   0.58136290389187417	;
  0.049208047279533249	  0.058318848562921952	  0.066883698533284769	  0.075173039769131922	  0.087593527794622872	  0.096817390820884530	   0.10537762757075937	   0.11355998342642566	   0.12659337334610024	   0.15192789119549283	   0.18197921432565631	   0.21487855493245159	   0.28271370967134801	   0.30971597556597769	   0.35022466022162541	   0.45289578606909103	   0.66322709576890782	   0.80635062766698329	   0.82379885657764862	   0.88156530242325681	   0.92436161503442482	   0.96898910758727763	;
  0.054678997896608066	  0.072532497876886343	  0.089485830824518442	   0.10128671217305653	   0.11898942151871132	   0.13172412361103647	   0.14328973588364396	   0.15414139892172279	   0.17103074594549347	   0.20205089658153333	   0.23680253802474505	   0.27566059594925324	   0.35813819921241435	   0.38534086536313444	   0.42804425638203131	   0.53507099793336443	   0.74345772713540559	   0.86562834416685730	   0.92892788269158511	   0.99913638471013866	    1.0453440053395153	    1.0926484315962346	;
  0.062647144173722816	  0.094593278815384652	   0.12549293981919707	   0.14173070548598318	   0.16943443411657658	   0.18852967774775251	   0.20515266810028390	   0.22034521604552956	   0.24338959679501032	   0.28295171899230964	   0.32352426589063266	   0.36826409610763738	   0.47644591221315336	   0.50361876628454183	   0.54943068273180118	   0.66372670582228688	   0.83445876922996165	   0.95926716213760022	    1.0989052178704721	    1.1954304177378570	    1.2492976546163936	    1.3027245697219567	;
  0.068137243605767339	   0.11061737745857056	   0.15046582885993728	   0.17464964640731667	   0.21477406530840285	   0.23949487544886988	   0.26014628449477378	   0.27831240918612354	   0.30485569398376466	   0.35023243907567625	   0.39851092057271503	   0.44727599009590030	   0.56323002687646651	   0.60267649165278792	   0.65749062077591169	   0.78502383426026934	   0.94350150357042262	    1.0882118526740339	    1.2580332475083884	    1.3777823517161785	    1.4403787128631662	    1.5011298705603768	;
  0.071856938223564662	   0.12485031848978202	   0.17463391103816159	   0.21651242591105932	   0.26846685684847743	   0.29653927280550307	   0.31983777259449447	   0.34068047072595342	   0.37132144815019097	   0.42233174847173210	   0.48140320912410667	   0.54049459428608548	   0.65648039025969984	   0.71005125655960666	   0.78186419764235260	   0.93296909819188645	    1.0963078927073899	    1.2670161597632057	    1.4426213948249078	    1.5825139771030710	    1.6551369387603212	    1.7249103627188360	;
  0.069886147460121659	   0.14947336272255476	   0.23437592886909867	   0.29818512189077884	   0.36269506035477206	   0.39788502038733675	   0.42742052590530899	   0.45408716964349694	   0.49441995387040805	   0.56852962732183709	   0.64364201840808766	   0.71796857087584565	   0.87129656077287188	   0.93479793748646445	    1.0293691709776582	    1.2356979090176647	    1.4468676760046113	    1.6380786665072948	    1.8154117259152678	    1.9719651512363927	    2.0593143892144092	    2.1448397885685933	;
  0.066159287093365438	   0.17147823303005991	   0.27909215856271702	   0.35230973785234360	   0.42453776135059351	   0.46754018024138566	   0.50410626588040985	   0.53719442730677236	   0.58716723502967949	   0.67681207655584452	   0.77072220845104467	   0.86479350568404278	    1.0379639068237709	    1.1132143379974724	    1.2220642054217148	    1.4318449343448645	    1.6955065529934614	    1.9438235898441509	    2.1306981775768423	    2.2986471290745256	    2.3958694276968053	    2.4922286472712627	;
  0.060672646586609667	   0.19315406472381963	   0.32360738641692410	   0.40866441748378640	   0.48989079822797427	   0.53715934272531229	   0.57814378744784278	   0.61570283992903652	   0.67301441784808880	   0.77854467496679813	   0.88746065106144478	   0.99410831714640890	    1.1965137123696841	    1.2853142167618605	    1.4137685846305010	    1.6327685121865985	    1.9346720062814535	    2.2259537861236636	    2.4470290106964949	    2.6366981935341034	    2.7466278218043643	    2.8559234203852202	;
  0.051324087267362692	   0.21384142005947229	   0.37054678225102206	   0.46873959366794099	   0.56103252643501078	   0.61492503745897942	   0.66137952029680747	   0.70407901205571743	   0.76923501331862931	   0.88506957648306350	    1.0042792463140802	    1.1224217539257133	    1.3506829465175352	    1.4494082806909787	    1.5914279286593946	    1.8561455846219059	    2.1800473654320478	    2.5057675657322851	    2.7699146879900804	    2.9947272243386469	    3.1246522576122522	    3.2538208184537227	;
  0.037962808897636917	   0.23180437930723186	   0.42028567045468568	   0.53719365400652919	   0.64109518943337285	   0.70068669533584393	   0.75164177049872893	   0.79847877069931184	   0.86935184886558226	   0.99296069340809057	    1.1240077404978681	    1.2532866952995736	    1.5038998360879281	    1.6145237869072437	    1.7729169991018898	    2.0725634111789395	    2.4295109819671308	    2.7925858755610204	    3.0980709529260273	    3.3713961411919788	    3.5314971548363556	    3.6910448962241311	;
  0.022307763282911574	   0.24904765094532064	   0.47220325877565067	   0.61483397826668618	   0.74533566451018063	   0.81874152742711570	   0.87973851806570103	   0.93366279037237143	    1.0125584807728987	    1.1442408003177409	    1.2851322426716130	    1.4254694327649935	    1.7064470162822596	    1.8290493194129518	    2.0050897744444529	    2.3465075295033846	    2.7373983688944157	    3.1379352857541969	    3.5001078588979961	    3.8554617608585415	    4.0691325475536484	    4.2831206419151870	;
  0.023054682076533113	   0.27369921871059755	   0.52203041263687144	   0.68562932612098226	   0.84651920488630150	   0.93611617881018960	    1.0100934214459658	    1.0754049852102747	    1.1702687426228839	    1.3227266762417296	    1.4753123467689824	    1.6285775940727256	    1.9389351409399265	    2.0795025441171919	    2.2859229357623816	    2.6701620936734214	    3.0725058097448699	    3.5019939715289752	    3.9568722588057401	    4.4447937443591865	    4.7438954113433836	    5.0444768029111025	;
  0.050471412163627313	   0.31034365271118219	   0.57619408362224267	   0.75803260466869316	   0.93444577532510109	    1.0288421971208175	    1.1058261522713531	    1.1731364359507928	    1.2707100394898911	    1.4327155025127334	    1.6051267302311059	    1.7783959378166003	    2.1148557733911781	    2.2660377294482474	    2.4876601611090265	    2.9036821992891966	    3.3193906083772911	    3.7817119998303403	    4.3445733204539545	    4.9675311271469029	    5.3523809233747173	    5.7397834812037392	;
   0.11923974467346142	   0.37604414532557762	   0.64538948485913117	   0.83743511974043772	    1.0289848235281149	    1.1248532254799708	    1.2022579470363592	    1.2705126010879275	    1.3706318485681142	    1.5445030388445207	    1.7407316063857137	    1.9387944197202920	    2.3001593571393162	    2.4632532404510905	    2.7001337533293310	    3.1472783546778902	    3.5984251108434107	    4.1284221471329854	    4.8235456532436034	    5.6227663636153276	    6.1203833570018977	    6.6219795812282385	;
   0.26533270708856166	   0.50096052787794310	   0.74905255436186069	   0.93482214573021405	    1.1402946040514401	    1.2405652076686744	    1.3216169940284266	    1.3940475565225829	    1.5016979862534026	    1.6924875855931738	    1.9023217908033094	    2.1133521647804225	    2.5108394106023382	    2.6880742580872350	    2.9446516449521183	    3.4224048477595419	    3.9300748839978916	    4.5847811563943619	    5.4594901953931041	    6.4936266191008691	    7.1398051024461680	    7.7912329443321635	;
   0.48152397445834394	   0.69311176637474592	   0.92517617092919513	    1.1025383991439155	    1.2861337472847270	    1.3850825935227218	    1.4682539226438904	    1.5435503384021059	    1.6574877124012140	    1.8621705930732348	    2.0761894993891921	    2.2918139864584752	    2.7216218283526232	    2.9167291159928759	    3.2002148301013316	    3.7120343418243178	    4.2620506619079581	    5.0933492230289010	    6.2157864135562502	    7.5155085166351059	    8.3198074731760538	    9.1285915871789083	;
   0.72460040353617761	   0.91445823906299473	    1.1131678631162700	    1.2580403055401170	    1.4127423031554993	    1.5089657999462389	    1.5937505168504682	    1.6730256479542618	    1.7955601345299657	    2.0155318799429258	    2.2410703147098974	    2.4639028927120412	    2.9288867994166039	    3.1353993298130622	    3.4353762074502465	    3.9727496042142323	    4.6042097050208017	    5.6621852251119593	    7.0636066319048165	    8.6125885920635188	    9.5582427077953689	    10.506559865380872	;
    1.0031955978372931	    1.1896766233972287	    1.3707868004147505	    1.4925006564749819	    1.6204520467790033	    1.7032787142960022	    1.7790422982918461	    1.8532170889829525	    1.9733994448085508	    2.2112444908447273	    2.4531793763772405	    2.6954811315909177	    3.1949136838111247	    3.4077732781676664	    3.7207837665497543	    4.3170153557571371	    5.2255501320920077	    6.5489216517090068	    8.2585678588505633	    10.048425777220729	    11.132266175316323	    12.218154769055905	;
    1.2000872224213066	    1.4407759862280822	    1.6735617464733961	    1.8229215980165765	    1.9649240525628837	    2.0431536188037596	    2.1065077148589388	    2.1603015340895633	    2.2465484980844055	    2.4370272021200110	    2.6753247265122133	    2.9375762035356630	    3.4989524009188071	    3.7421470211291417	    4.1301985506045016	    5.0321163685526926	    6.6226236566147465	    8.0651557292202831	    9.8307513643054580	    11.774320963423740	    12.962576162446490	    14.152154807511844	;
    1.2375155464758356	    1.5227855160948747	    1.7982439861562820	    1.9672390117748526	    2.1155858353550747	    2.1915722289019555	    2.2519473820278408	    2.3032270549948208	    2.3822779119450739	    2.5597782356266960	    2.7995816398415565	    3.0720629889622360	    3.6908382073072654	    4.0027476188600373	    4.5009618796356472	    5.8027441485340914	    7.4985981024461061	    8.9154099267149842	    10.719606249040325	    12.760918764690508	    13.988776608701043	    15.213715790956176	;
    1.2437301546731618	    1.5451125684436680	    1.8360408699321227	    2.0127921592327089	    2.1652519695872168	    2.2412921542638378	    2.3005187121606072	    2.3511231010778384	    2.4278337059464645	    2.6036745907151917	    2.8440813158303140	    3.1211740706439399	    3.7659853779254391	    4.1105937792044323	    4.6545942888328362	    6.0823888750168322	    7.8000090331420777	    9.2086209538649477	    11.029897890076802	    13.108803105098774	    14.348406974371988	    15.584636348933351	;
    1.2412913936368231	    1.5885789292171475	    1.9238544330840632	    2.1249800990390133	    2.2950017136255356	    2.3777645824973086	    2.4406909487300954	    2.4915042902030842	    2.5646945418511193	    2.7303637627927597	    2.9717246729627065	    3.2627457098808916	    4.0050245146437415	    4.4669773242319275	    5.1734944476445373	    6.8808886866945995	    8.6402364859061347	    10.022169996216070	    11.894709750724966	    14.087137083031278	    15.354700960274549	    16.621227208565422	;
    1.1735327752860587	    1.5729324841744572	    1.9608929485798980	    2.1991123771767729	    2.4063282837444455	    2.5098727981788125	    2.5902847971169711	    2.6577021932109943	    2.7505265491534439	    2.9064194517239095	    3.1308759163715352	    3.4383616219978985	    4.5043036100968861	    5.0663848620217893	    5.9485454590778071	    7.8369651864498460	    9.5574488039597654	    10.914042734814526	    12.886313022427791	    15.184007428478921	    16.505031884754029	    17.822618774291492	;
    1.1408010277277760	    1.5566163875956689	    1.9614310206778738	    2.2126515365997448	    2.4350766369566803	    2.5488298984211286	    2.6385513181954074	    2.7146762385462879	    2.8184352558875396	    2.9831037476753486	    3.1975154862367341	    3.5121035130835332	    4.6741913219090510	    5.2600344249135924	    6.1860426326045257	    8.1417253699695067	    9.8571653340347911	    11.188741949964124	    13.205940594717607	    15.526050110539165	    16.869377831365806	    18.206041924525056	;
    1.0377334782246537	    1.4945740000367913	    1.9420013255781361	    2.2278522522752242	    2.4940449202426405	    2.6388881545991367	    2.7567646213244057	    2.8584732491371061	    2.9972321547830139	    3.2050176546136582	    3.4092166590305872	    3.7481538622713537	    5.0878577997198624	    5.7344381809068228	    6.7511925970094246	    8.8952153169094146	    10.625438752108913	    11.873789836553714	    14.018263279842806	    16.381550811767845	    17.779187502830705	    19.166826218852695	;
   0.86359518613386554	    1.3712785203719755	    1.8735543779917720	    2.2041317355266679	    2.5234824349283453	    2.7042002452672280	    2.8553538539944499	    2.9902722239586761	    3.1891032102724171	    3.5287254850313077	    3.8684801722570157	    4.2724531645258423	    5.5166043391322575	    6.2107262392235816	    7.2970892805431120	    9.5869901672495264	    11.465842835503924	    12.914794157619646	    15.028682571047913	    17.404497846844951	    18.841090659921417	    20.274698795193501	;
   0.64326554650502565	    1.2082416338818245	    1.7745112794858462	    2.1558249756451877	    2.5318497488478591	    2.7492813253303328	    2.9341324126634647	    3.1025168747692753	    3.3614359383198624	    3.8588427282278772	    4.3818289987991861	    4.8406705112858770	    5.9433915598189522	    6.6687774501813575	    7.8029121660852914	    10.083566778219055	    12.143697735792575	    13.956160654567460	    16.085741553392776	    18.451683778334480	    19.899435991708192	    21.350995199348265	;
   0.37411824317228187	    1.0079626870354050	    1.6537509074783443	    2.1003266717912785	    2.5504545077937966	    2.8140059096302781	    3.0384618212301668	    3.2420346415265473	    3.5496499879762844	    4.1012960546937069	    4.6986503928612118	    5.2794304373261784	    6.5116953934476793	    7.2313872011318345	    8.3543744557522572	    10.566125211868719	    12.817876433527292	    14.995726168131320	    17.237272319396304	    19.596470528519390	    21.036737032676907	    22.482857556888742	;
  0.090408675753738954	   0.79768723655871498	    1.5307983558181317	    2.0500571542259847	    2.5793737350736441	    2.8884678207688101	    3.1504008070844112	    3.3864282865554491	    3.7388644164660576	    4.3483033572364223	    4.9980207563130739	    5.6643674926599115	    7.1181476428660737	    7.8333944936023068	    8.9164071207216047	    11.054405531822452	    13.486504096331105	    15.989189618347982	    18.390210735151353	    20.753332393604499	    22.178991916216624	    23.608802643323369	]; 

% Fuel Properties
engine.fuel = class_REVS_fuel('FTAG 25842');

% Idle Speed
engine.idle_speed_radps = class_REVS_dynamic_lookup;
engine.idle_speed_radps.axis_1.signal =  'veh_spd_mps'; 
engine.idle_speed_radps.axis_1.breakpoints = [	    0.00000000000000000	    10.000000000000000		]; 
engine.idle_speed_radps.table = [	     65.973445725385659	;     65.973445725385659		]; 

% Pedal Calibration
engine.pedal_map_type = enum_engine_pedal_map_type.max_engine_power;

% Calibration Adjustment Factors
% -- None -- 
